<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" exclude-result-prefixes="fo">
  <xsl:output method="xml" version="1.0" omit-xml-declaration="no" indent="yes"/>
  
  <xsl:param name="licencse" select="''"/> 
  <xsl:param name="date" select="''"/>
  
  
  <!-- ========================= -->
  <!-- root element: projectteam -->
  <!-- ========================= -->
  <xsl:template match="List_of_results">
    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="Arial">
      
      <fo:layout-master-set>
        <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm">
          <fo:region-body margin-top="3.0cm" margin-bottom="1.5cm"/>
		      <fo:region-before extent="3.0cm"/>
          <fo:region-after extent="1.0cm"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="simpleA4">
   		
   		<fo:static-content flow-name="xsl-region-before" display-align="before">
      	  <fo:block font-size="9pt" text-align="center" space-after="3mm">
            Министерство спорта, туризма и молодежной политики Российской Федерации
          </fo:block>
          <fo:block font-size="9pt" text-align="center" space-after="3mm">
            Федерация каратэ России
          </fo:block>
          <fo:block font-size="9pt" text-align="center" space-after="3mm">
             <xsl:value-of select="@event"/>
          </fo:block>
          <fo:block font-size="9pt" space-before="3mm">
            <fo:table table-layout="fixed" width="100%" border-collapse="separate">
              <fo:table-column column-width="8.5cm"/>
              <fo:table-column column-width="8.5cm"/>
              <fo:table-body>
                <fo:table-row>
                  <fo:table-cell border-bottom="1pt double black">
                    <fo:block white-space-collapse="false" text-align="left">
     	                <xsl:value-of select="@eventaddress"/>
     	              </fo:block>      
                  </fo:table-cell>
                  <fo:table-cell border-bottom="1pt double black">
                    <fo:block white-space-collapse="false" text-align="right">
     	                 <xsl:call-template name ="reverseDate">
                        <xsl:with-param name ="str" select ="@date"/>
                       </xsl:call-template>
     	              </fo:block>      
                  </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
   		</fo:static-content>
   		
  		<fo:static-content flow-name="xsl-region-after">
          	<fo:block font-size="8pt" text-align="center"> 
          		стр. <fo:page-number/> из <fo:page-number-citation  ref-id="theEnd" />
          	</fo:block>
   		</fo:static-content>
        
        <fo:flow flow-name="xsl-region-body"  space-before="5mm">
          <fo:block font-size="16pt" font-weight="bold"  space-after="5mm" text-align="center">
          Справка главной судейской коллегии
          </fo:block>
          <fo:block font-size="12pt" space-after="5mm" text-align="center">
          
          </fo:block>
          <xsl:apply-templates select="Results"/>      
  
          <fo:block font-size="12pt" space-before="1cm">
            <fo:table table-layout="fixed" width="100%" border-collapse="separate">
              <fo:table-column column-width="8.5cm"/>
              <fo:table-column column-width="8.5cm"/>
              <fo:table-body>
                <fo:table-row>
                  <fo:table-cell>
                    <fo:block white-space-collapse="false" space-after="10mm" text-align="center">
     	                Главный    секретарь
     	              </fo:block>      
                  </fo:table-cell>
                  <fo:table-cell>
                    <fo:block white-space-collapse="false" space-after="10mm" text-align="center">
     	              </fo:block>      
                  </fo:table-cell>
                </fo:table-row>
              </fo:table-body>
            </fo:table>
          </fo:block>
          <fo:block id="theEnd" />
        </fo:flow>
     </fo:page-sequence>   
    </fo:root>
  </xsl:template>
  
  <xsl:template match="Results">
    <xsl:apply-templates select="Result"/>
  </xsl:template>
  
  <xsl:template name="ResultInd" match="Result">
    <xsl:if test="CategoryType = ''">
     <fo:block font-size="7pt">
            <fo:table table-layout="fixed" width="100%" border-collapse="separate">
              <fo:table-column column-width="1cm"/>
              <fo:table-column column-width="4cm"/>
              <fo:table-column column-width="1.5cm"/>
              <fo:table-column column-width="2cm"/>
              <fo:table-column column-width="4.5cm"/>
              <fo:table-column column-width="4cm"/>
              <fo:table-body>
                
      <xsl:if test="Nextcat = 'true'">
        <fo:table-row>
        <fo:table-cell number-columns-spanned="6">
        <fo:block white-space-collapse="false" space-after="10mm" color="white">
     	  <xsl:text>  
     	  </xsl:text><xsl:value-of select="Category"/>
		    </fo:block>
        </fo:table-cell>
        </fo:table-row>
        <fo:table-row keep-with-next="always">
        <fo:table-cell number-columns-spanned="6">
        <fo:block >
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="Category"/>
        </fo:block>
        </fo:table-cell>
        </fo:table-row>
        <fo:table-row keep-with-next="always">
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Место</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Фамилия Имя</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Дата рождения</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Квалифиция</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Регион</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">ФИО Тренера</fo:block>
        </fo:table-cell>
        </fo:table-row>
     </xsl:if>
     <xsl:variable  name="others" select="Others"/> 
     <xsl:variable  name="qualification" select="substring-before($others, '/')"/>  
     <xsl:variable  name="restofstring" select="substring-after($others, '/')"/>
     <xsl:variable  name="patronomic" select="substring-after($restofstring, '/')"/>
     <xsl:variable  name="coach" select="substring-before($restofstring, '/')"/>
     <fo:table-row >
      <fo:table-cell border="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="Place"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border="0.5pt solid black">
        <fo:block>
         <xsl:value-of select="Name"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell text-align="center" display-align="center" border="0.5pt solid black">
        <fo:block>
        <xsl:call-template name ="reverseDate">
          <xsl:with-param name ="str" select ="DayOfBirth"/>
        </xsl:call-template>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell text-align="center" display-align="center" border="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="$qualification" /> 
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="Federal_Association_Full"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="$coach" /> 
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
    </fo:table-body>
            </fo:table>
          </fo:block>
   </xsl:if>
   <xsl:if test="CategoryType = 't'">
     <fo:block font-size="7pt">
            <fo:table table-layout="fixed" width="100%" border-collapse="separate" border-bottom="0.5pt solid black">
              <fo:table-column column-width="1cm"/>
              <fo:table-column column-width="4cm"/>
              <fo:table-column column-width="1.5cm"/>
              <fo:table-column column-width="2cm"/>
              <fo:table-column column-width="4.5cm"/>
              <fo:table-column column-width="4cm"/>
              <fo:table-body>
                
      <xsl:if test="Nextcat = 'true'">
        <fo:table-row>
        <fo:table-cell number-columns-spanned="4">
        <fo:block white-space-collapse="false" space-after="10mm" color="white">
     	  <xsl:text>  
     	  </xsl:text><xsl:value-of select="Category"/>
		    </fo:block>
        </fo:table-cell>
        </fo:table-row>
        <fo:table-row keep-with-next="always">
        <fo:table-cell number-columns-spanned="4">
        <fo:block >
          <xsl:attribute name="font-weight">bold</xsl:attribute>
          <xsl:attribute name="font-style">italic</xsl:attribute>
          <xsl:attribute name="font-size">10pt</xsl:attribute>
          <xsl:value-of select="Category"/>
        </fo:block>
        </fo:table-cell>
        </fo:table-row>
        <fo:table-row keep-with-next="always">
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Место</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Фамилия Имя</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Дата рождения</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Квалифиция</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">Регион</fo:block>
        </fo:table-cell>
        <fo:table-cell border="0.5pt solid black">
        <fo:block font-size="6pt">ФИО Тренера</fo:block>
        </fo:table-cell>
        </fo:table-row>
     </xsl:if>
     <fo:table-row >
      <fo:table-cell border-top="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="Place"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-top="0.5pt solid black"  border-bottom="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
         <xsl:value-of select="Name"/>:
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-top="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-top="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-top="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-top="0.5pt solid black" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
        </fo:block>
      </fo:table-cell>
      </fo:table-row>
        <xsl:if test="Teammembers/Teammember[1]">
         <xsl:apply-templates select="Teammembers"/>
        </xsl:if>
    </fo:table-body>
    </fo:table>
   </fo:block>
   </xsl:if>  
  </xsl:template>
  
  <xsl:template match="Teammembers">
    <xsl:apply-templates select="Teammember"/>	       
  </xsl:template>
  
  <xsl:template match="Teammember">
     <xsl:variable  name="others" select="OthersTeam"/> 
     <xsl:variable  name="qualification" select="substring-before($others, '/')"/>  
     <xsl:variable  name="restofstring" select="substring-after($others, '/')"/>
     <xsl:variable  name="patronomic" select="substring-after($restofstring, '/')"/>
     <xsl:variable  name="coach" select="substring-before($restofstring, '/')"/>
      <fo:table-row>
      <fo:table-cell border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
        </fo:block>
      </fo:table-cell>
       <fo:table-cell border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block keep-with-next="always">
          <xsl:value-of select="NameTeam"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell text-align="center" display-align="center" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block keep-with-next="always">
        <xsl:call-template name ="reverseDate">
          <xsl:with-param name ="str" select ="DayOfBirthTeam"/>
        </xsl:call-template>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell text-align="center" display-align="center" border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="$qualification" /> 
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="./../../Federal_Association_Full"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-left="0.5pt solid black" border-right="0.5pt solid black">
        <fo:block>
          <xsl:value-of select="$coach" /> 
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
  </xsl:template>
  
  <xsl:template name="reverseDate">
     <xsl:param name="str"/>
     <xsl:variable  name="year" select="substring-before($str, '-')"/>  
     <xsl:variable  name="restofstring" select="substring-after($str, '-')"/>
     <xsl:variable  name="day" select="substring-after($restofstring, '-')"/>
     <xsl:variable  name="month" select="substring-before($restofstring, '-')"/>
     <xsl:value-of select="$day" />-<xsl:value-of select="$month" />-<xsl:value-of select="$year" />   
  </xsl:template>
  
    
</xsl:stylesheet>
