/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.sportdata.setpp.anzeige.beans.AnzeigeMaster;
import org.sportdata.setpp.anzeige.constants.MainConstants;
import org.sportdata.setpp.anzeige.properties.helper.AnzeigePropertiesHelper;

public class DateUtils {
    public static String getLogDateFormated() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static String getLogDateFormatedMS() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static String getLogDateFormatedMSShort() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss:SSS");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static Date convertFromString(String datestring, String dateformat) {
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            Date date = df.parse(datestring);
            return date;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String getDateFormatedShort() {
        String strdate = "";
        Date aktdate = new Date();
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static String getDateFormatedShortLicense(Date aktdate) {
        String strdate = "";
        if (aktdate != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                strdate = df.format(aktdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return strdate;
    }

    public static boolean isValidAppRequestByDateOfRunningClock(String datestr) {
        System.out.println("Clock is not running -> check if request was during running clock..." + datestr);
        boolean isok = false;
        ArrayList<String> clockstart = AnzeigeMaster.getInstance().getAnzeige().getClock().getClockstart();
        ArrayList<String> clockend = AnzeigeMaster.getInstance().getAnzeige().getClock().getClockend();
        if (clockstart.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date daterequest = sdf.parse(datestr);
                int i = 0;
                while (i < clockstart.size()) {
                    System.out.println("Start: " + clockstart.get(i));
                    System.out.println("End: " + clockend.get(i));
                    Date datestart = sdf.parse(clockstart.get(i));
                    Date dateend = sdf.parse(clockend.get(i));
                    if (daterequest.compareTo(datestart) == 0) {
                        isok = true;
                        break;
                    }
                    if (daterequest.compareTo(dateend) == 0) {
                        isok = true;
                        break;
                    }
                    if (daterequest.compareTo(datestart) > 0 && daterequest.compareTo(dateend) < 0) {
                        isok = true;
                        break;
                    }
                    ++i;
                }
                if (isok) {
                    System.out.println("->Score Request is VALID!");
                } else {
                    System.out.println("->Score Request is INVALID!");
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return isok;
    }

    public static boolean isValidClickerScoreAfterMatch(String scoretime) {
        System.out.println("Clock is not running -> check if score was during running clock or within allowed timeframe...");
        boolean isok = false;
        ArrayList<String> clockend = AnzeigeMaster.getInstance().getAnzeige().getClock().getClockend();
        if (clockend.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                System.out.println("Clock stop time: " + clockend.get(clockend.size() - 1));
                System.out.println("Score time: " + scoretime);
                Date dateclockend = sdf.parse(clockend.get(clockend.size() - 1));
                Date datescoretime = sdf.parse(scoretime);
                long timedifference = MainConstants.MAX_TIME_DIFF;
                try {
                    if (!AnzeigePropertiesHelper.getPpwkfscoremaxtimedifference().equals("")) {
                        timedifference = Long.parseLong(AnzeigePropertiesHelper.getPpwkfscoremaxtimedifference());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                dateclockend.setTime(dateclockend.getTime() + timedifference);
                System.out.println("Clock stop time frame: " + sdf.format(dateclockend));
                if (datescoretime.compareTo(dateclockend) <= 0) {
                    isok = true;
                }
                if (isok) {
                    System.out.println("->Request is VALID!");
                } else {
                    System.out.println("->Request is INVALID!");
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return isok;
    }

    public static boolean checkIsAfter(String time1, String time2) {
        System.out.println("Check if we can start clock");
        boolean isafter = true;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date datetime1 = sdf.parse(time1);
            Date datetime2 = sdf.parse(time2);
            datetime2.setTime(datetime2.getTime() + 5000L);
            if (datetime1.compareTo(datetime2) < 0) {
                isafter = false;
            }
            if (isafter) {
                System.out.println("->Start clock if blocked!");
            } else {
                System.out.println("->Start clock is OK!");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return isafter;
    }
}

