/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.server.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sportdata.setpp.anzeige.beans.AnzeigeMaster;
import org.sportdata.setpp.anzeige.beans.ScoringObject;
import org.sportdata.setpp.anzeige.utils.DateUtils;

public class ScoringServlet
extends HttpServlet {
    public static final String SERVLET_URL = "scoring";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        response.getWriter().println("Scoring Request GET 200");
        String command = "";
        try {
            command = request.getParameter("command");
            if (command != null) {
                if (AnzeigeMaster.getInstance().isHantei()) {
                    if (command.equals("red_score_1_flags_2")) {
                        AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", 2, null);
                        AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", 2, null);
                    }
                    if (command.equals("red_score_1_flags_3")) {
                        AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", 3, null);
                        AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", 1, null);
                    }
                    if (command.equals("blue_score_1_flags_3")) {
                        AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", 1, null);
                        AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", 3, null);
                    }
                } else {
                    if (command.equals("red_score_1_flags_2")) {
                        AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Yuko", 2, null);
                    }
                    if (command.equals("blue_score_1_flags_2")) {
                        AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Yuko", 2, null);
                    }
                    if (command.equals("red_score_1_flags_3")) {
                        AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Yuko", 3, null);
                    }
                    if (command.equals("blue_score_1_flags_3")) {
                        AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Yuko", 3, null);
                    }
                    if (command.equals("red_score_2_flags_2")) {
                        AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Waza-ari", 2, null);
                    }
                    if (command.equals("blue_score_2_flags_2")) {
                        AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Waza-ari", 2, null);
                    }
                    if (command.equals("red_score_3_flags_2")) {
                        AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Ippon", 2, null);
                    }
                    if (command.equals("blue_score_3_flags_2")) {
                        AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "Ippon", 2, null);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            String message = "";
            if (br != null) {
                message = br.readLine();
            }
            if (message != null && !message.trim().equals("") && message.indexOf("ScoreAction") > -1) {
                Gson gson = new Gson();
                JsonParser jsonParser = new JsonParser();
                String json = jsonParser.parse(message).getAsJsonObject().toString();
                ScoringObject obj = (ScoringObject)gson.fromJson(json, ScoringObject.class);
                if (json.indexOf("batterylevel") > -1) {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(113, "batterylevel," + obj.getReferee() + "," + obj.getBatterylevel());
                }
                obj.printObject();
                boolean hasvalidscorer = false;
                if (obj.getScoreName().equals("point")) {
                    hasvalidscorer = true;
                    if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                        if (AnzeigeMaster.getInstance().isTestmode()) {
                            AnzeigeMaster.getInstance().processTestScore(obj);
                        } else if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue() || DateUtils.isValidClickerScoreAfterMatch(obj.getGenerated())) {
                            ScoringServlet.sendScore(obj);
                        } else if (AnzeigeMaster.getInstance().isHantei()) {
                            ScoringServlet.sendScoreHantei(obj);
                        }
                        response.setContentType("text/html");
                        response.setStatus(200);
                        response.getWriter().println("Scoring request successfully processed");
                    } else {
                        response.setContentType("text/html");
                        response.setStatus(400);
                        response.getWriter().println("No assignment for imei and referee");
                    }
                }
                if (!hasvalidscorer) {
                    response.setContentType("text/html");
                    response.setStatus(400);
                    response.getWriter().println("Request Json not valid");
                }
            } else {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Request Json not valid");
            }
        }
        catch (Exception e) {
            try {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Error processing scoring");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static synchronized void sendScore(ScoringObject obj) {
        obj.setGenerated(DateUtils.getLogDateFormatedMS());
        int score = Math.round(obj.getScoreValue());
        String type = "";
        if (score > 0 && score < 4 && obj.getReferee() > 0 && obj.getReferee() < 5) {
            if (obj.getScorer().indexOf("RED") > -1) {
                AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, obj.getGenerated() + " [JUDGE " + obj.getReferee() + "] [VALUE " + obj.getScoreValue() + "] [RED]");
                AnzeigeMaster.getInstance().getRefereesPointsRed().put(obj.getReferee(), obj);
                Vector<Object> scorered = AnzeigeMaster.getInstance().countScoreRed();
                if (scorered.size() > 0) {
                    if ((Integer)scorered.get(0) == 1) {
                        type = "Yuko";
                    }
                    if ((Integer)scorered.get(0) == 2) {
                        type = "Waza-ari";
                    }
                    if ((Integer)scorered.get(0) == 3) {
                        type = "Ippon";
                    }
                    AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), type, (Integer)scorered.get(1), (ArrayList)scorered.get(2));
                    AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, "[SCORE DETECTED] " + DateUtils.getLogDateFormatedMS() + " [VALUE " + type.toUpperCase() + "] [VOTES " + String.valueOf(scorered.get(1)) + "] [RED] " + ((ArrayList)scorered.get(2)).toString());
                }
            }
            if (obj.getScorer().indexOf("BLUE") > -1) {
                AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, obj.getGenerated() + " [JUDGE " + obj.getReferee() + "] [VALUE " + obj.getScoreValue() + "] [BLUE]");
                AnzeigeMaster.getInstance().getRefereesPointsBlue().put(obj.getReferee(), obj);
                Vector<Object> scoreblue = AnzeigeMaster.getInstance().countScoreBlue();
                if (scoreblue.size() > 0) {
                    if ((Integer)scoreblue.get(0) == 1) {
                        type = "Yuko";
                    }
                    if ((Integer)scoreblue.get(0) == 2) {
                        type = "Waza-ari";
                    }
                    if ((Integer)scoreblue.get(0) == 3) {
                        type = "Ippon";
                    }
                    AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), type, (Integer)scoreblue.get(1), (ArrayList)scoreblue.get(2));
                    AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, "[SCORE DETECTED] " + obj.getGenerated() + " [VALUE " + type.toUpperCase() + "] [VOTES " + String.valueOf(scoreblue.get(1)) + "] [BLUE]" + ((ArrayList)scoreblue.get(2)).toString());
                }
            }
        }
    }

    public static synchronized void sendScoreHantei(ScoringObject obj) {
        obj.setGenerated(DateUtils.getLogDateFormatedMS());
        int score = Math.round(obj.getScoreValue());
        boolean addscore = false;
        int reflimit = 4;
        if (score > 0 && score < 4 && obj.getReferee() > 0 && obj.getReferee() < 6) {
            if (obj.getScorer().indexOf("RED") > -1 && AnzeigeMaster.getInstance().getRefereesPointsRedHantei().size() + AnzeigeMaster.getInstance().getRefereesPointsBlueHantei().size() < reflimit && !AnzeigeMaster.getInstance().hasrefereevoteHantei(obj.getReferee())) {
                AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, obj.getGenerated() + " [JUDGE " + obj.getReferee() + "] [HANTEI VALUE " + obj.getScoreValue() + "] [RED]");
                AnzeigeMaster.getInstance().getRefereesPointsRedHantei().put(obj.getReferee(), obj);
                addscore = true;
            }
            if (obj.getScorer().indexOf("BLUE") > -1 && AnzeigeMaster.getInstance().getRefereesPointsRedHantei().size() + AnzeigeMaster.getInstance().getRefereesPointsBlueHantei().size() < reflimit && !AnzeigeMaster.getInstance().hasrefereevoteHantei(obj.getReferee())) {
                AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, obj.getGenerated() + " [JUDGE " + obj.getReferee() + "] [HANTEI VALUE " + obj.getScoreValue() + "] [BLUE]");
                AnzeigeMaster.getInstance().getRefereesPointsBlueHantei().put(obj.getReferee(), obj);
                addscore = true;
            }
            if (AnzeigeMaster.getInstance().getRefereesPointsRedHantei().size() + AnzeigeMaster.getInstance().getRefereesPointsBlueHantei().size() == reflimit && addscore) {
                AnzeigeMaster.getInstance().showScore(1, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", AnzeigeMaster.getInstance().getRefereesPointsRedHantei().size(), null);
                AnzeigeMaster.getInstance().showScore(2, AnzeigeMaster.getInstance().getAnzeige().getAcontrol(), "HANTEI", AnzeigeMaster.getInstance().getRefereesPointsBlueHantei().size(), null);
            }
        }
    }
}

