/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setpp.anzeige.components.ProtestComponent;
import org.sportdata.setpp.anzeige.constants.MainConstants;
import org.sportdata.setpp.anzeige.interfaces.ITimer;
import org.sportdata.setpp.anzeige.ressource.AnzeigeResource;
import org.sportdata.setpp.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setpp.anzeige.utils.License;
import org.sportdata.setpp.anzeige.version.Version;

public class ProtestClockPanel
extends JFrame
implements ActionListener,
ITimer {
    private static final long serialVersionUID = -1003801023381257450L;
    private JPanel a;
    private ProtestComponent b;
    private JButton c;
    private JLabel d;
    private JButton e;
    private JButton f;
    private JButton g;
    private int h;
    private JComboBox<String> i;
    private JLabel j;

    public ProtestClockPanel(ProtestComponent clock, int colormode) {
        this.b = clock;
        this.h = colormode;
        String colortitle = "";
        colortitle = colormode == 1 ? "AKA" : "AO";
        this.setTitle(colortitle + " VR - " + Version.getCopyright() + " (" + License.getLicense() + ")");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        if (colormode == 1) {
            this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 520) / 2, 400, 200);
        } else {
            this.setBounds((screenSize.width - 800) / 2, (screenSize.height - 130) / 2, 400, 200);
        }
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initComponent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ProtestClockPanel.this.getClock().sendCancel();
                ProtestClockPanel.this.stopClock();
                ProtestClockPanel.this.closeWindow();
            }
        });
        clock.setTimerlabel(this);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.c.requestFocus();
    }

    public void initComponent() {
        this.a = new JPanel();
        this.a.setLayout(new GridLayout(4, 1));
        this.c = new JButton(AnzeigeResource.getResourceString("general.stop"));
        this.c.addActionListener(this);
        this.e = new JButton("");
        this.e.addActionListener(this);
        this.e.setIcon(new ImageIcon("images/tick.png"));
        this.f = new JButton("");
        this.f.addActionListener(this);
        this.f.setIcon(new ImageIcon("images/cancel.png"));
        this.g = new JButton("");
        this.g.addActionListener(this);
        this.g.setIcon(new ImageIcon("images/vr_obststructed.png"));
        JLabel ltext = new JLabel("VR " + AnzeigeResource.getResourceString("general.timer"));
        JPanel pbuttons = new JPanel();
        pbuttons.add(ltext);
        pbuttons.add(this.c);
        pbuttons.add(this.e);
        pbuttons.add(this.f);
        pbuttons.add(this.g);
        this.d = new JLabel("");
        this.d.setFont(new Font("Dialog", 1, 20));
        if (this.h == 1) {
            this.d.setForeground(MainConstants.AKA_COLOR);
        } else {
            this.d.setForeground(MainConstants.AO_COLOR);
        }
        JPanel ptime = new JPanel();
        ptime.add(this.d);
        this.i = new JComboBox();
        this.i.addItem("");
        this.i.addItem("Yuko");
        this.i.addItem("Waza-ari");
        this.i.addItem("Ippon");
        this.i.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                ProtestClockPanel.this.b.setValueText(ProtestClockPanel.this.i.getSelectedItem().toString());
            }
        });
        this.i.setEnabled(true);
        this.j = new JLabel();
        this.j.setHorizontalAlignment(0);
        this.a.add(ptime);
        this.a.add(pbuttons);
        this.a.add(this.i);
        this.a.add(this.j);
        this.add(this.a);
    }

    public void stopClock() {
        this.b.stopClock();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source.equals(this.c)) {
            this.stopClock();
        }
        if (source.equals(this.e)) {
            this.stopClock();
            this.j.setIcon(new ImageIcon("images/protest-pos32.png"));
            if (this.h == 1) {
                this.b.fireAkaPosEvent();
            } else {
                this.b.fireAoPosEvent();
            }
        }
        if (source.equals(this.f)) {
            this.stopClock();
            this.j.setIcon(new ImageIcon("images/protest-neg32.png"));
            if (this.h == 1) {
                this.b.fireAkaNegEvent();
            } else {
                this.b.fireAoNegEvent();
            }
        }
        if (source.equals(this.g)) {
            this.stopClock();
            this.j.setIcon(new ImageIcon("images/vr_obststructed.png"));
            if (this.h == 1) {
                this.b.fireAkaObstructed();
            } else {
                this.b.fireAoObstructed();
            }
        }
    }

    @Override
    public void updateTimerLabel(String timestring) {
        this.d.setText(timestring);
        this.d.repaint();
    }

    public int getColormode() {
        return this.h;
    }

    public void setColormode(int colormode) {
        this.h = colormode;
    }

    public void closeWindow() {
        this.b.closeWindow(this.i.getSelectedItem().toString());
        this.setVisible(false);
        this.dispose();
    }

    public void firePosButton() {
        this.e.doClick();
    }

    public void fireNegButton() {
        this.f.doClick();
    }

    public void fireObstructedButton() {
        this.g.doClick();
    }

    public void setFullScreen() {
        this.b.changeFontsize(160);
        this.b.setExtendedState(6);
        this.b.getPcc().setExtendedState(6);
    }

    public void setNormalSize() {
        this.b.changeFontsize(80);
        this.b.setExtendedState(0);
        this.b.getPcc().setExtendedState(0);
    }

    public void setPoints(int index) {
        try {
            this.i.setSelectedIndex(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setClockSize(int w, int h) {
        this.b.setSize(w, h);
        this.b.getPcc().setSize(w, h);
    }

    public void setClockLocation(int x, int y) {
        this.b.setLocation(x, y);
    }

    public void setClockCloneLocation(int x, int y) {
        this.b.getPcc().setLocation(x, y);
    }

    public void setPenalties(int penalty, int penalty2) {
        this.b.setPenalties(penalty, penalty2);
    }

    public ProtestComponent getClock() {
        return this.b;
    }
}

