/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige.ticker;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MarqueePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -5077889561644074824L;
    protected boolean paintChildren;
    protected boolean scrollingPaused;
    protected int scrollOffset;
    protected int wrapOffset;
    private int a = -1;
    private int b;
    private int c;
    private boolean d = false;
    private int e = 50;
    private boolean f = false;
    private Timer g = new Timer(1000, this);

    public MarqueePanel() {
        this(5, 5);
    }

    public MarqueePanel(int scrollFrequency, int scrollAmount) {
        this.setScrollFrequency(scrollFrequency);
        this.setScrollAmount(scrollAmount);
        this.setLayout(new BoxLayout(this, 0));
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.paintChildren) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(-this.scrollOffset, 0);
        super.paintChildren(g);
        g2d.translate(this.scrollOffset, 0);
        if (this.isWrap()) {
            this.wrapOffset = this.scrollOffset - super.getPreferredSize().width - this.e;
            g2d.translate(-this.wrapOffset, 0);
            super.paintChildren(g);
            g2d.translate(this.wrapOffset, 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d2 = super.getPreferredSize();
        d2.width = this.a == -1 ? d2.width / 2 : this.a;
        return d2;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPreferredWidth() {
        return this.a;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.a = preferredWidth;
        this.revalidate();
    }

    public int getScrollAmount() {
        return this.b;
    }

    public void setScrollAmount(int scrollAmount) {
        this.b = scrollAmount;
    }

    public int getScrollFrequency() {
        return this.c;
    }

    public void setScrollFrequency(int scrollFrequency) {
        this.c = scrollFrequency;
        int delay = 1000 / scrollFrequency;
        this.g.setInitialDelay(delay);
        this.g.setDelay(delay);
    }

    public boolean isScrollWhenFocused() {
        return this.f;
    }

    public void setScrollWhenFocused(boolean scrollWhenFocused) {
        this.f = scrollWhenFocused;
    }

    public boolean isWrap() {
        return this.d;
    }

    public void setWrap(boolean wrap) {
        this.d = wrap;
    }

    public int getWrapAmount() {
        return this.e;
    }

    public void setWrapAmount(int wrapAmount) {
        this.e = wrapAmount;
    }

    public void startScrolling() {
        this.paintChildren = true;
        this.scrollOffset = -this.getSize().width;
        this.g.start();
    }

    public void stopScrolling() {
        this.g.stop();
        this.paintChildren = false;
        this.repaint();
    }

    public void pauseScrolling() {
        if (this.g.isRunning()) {
            this.g.stop();
            this.scrollingPaused = true;
        }
    }

    public void resumeScrolling() {
        if (this.scrollingPaused) {
            this.g.restart();
            this.scrollingPaused = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.scrollOffset += this.b;
        int width = super.getPreferredSize().width;
        if (this.scrollOffset > width) {
            this.scrollOffset = this.isWrap() ? this.wrapOffset + this.b : -this.getSize().width;
        }
        this.repaint();
    }
}

