/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige.ticker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.sportdata.setpp.anzeige.ticker.MarqueePanel;
import org.sportdata.setpp.anzeige.ticker.RelativeLayout;

public class MarqueePanelDemo
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    private MarqueePanel a;
    private JSpinner b;
    private JSpinner c;
    private JSpinner d;
    private JSpinner e;

    MarqueePanelDemo() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(Color.ORANGE);
        JComponent north = this.a();
        JPanel center = this.createCenterPanel();
        JComponent south = this.b();
        this.add((Component)north, "North");
        this.add((Component)center, "Center");
        this.add((Component)south, "South");
    }

    private JComponent a() {
        this.a = new MarqueePanel();
        this.a.setPreferredWidth(199);
        this.a.setOpaque(false);
        JLabel label1 = new JLabel();
        label1.setText("Here is a long string of text.");
        Font f = new Font("SansSerif", 0, 24);
        label1.setFont(f);
        this.a.add(label1);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.add(this.a);
        return panel;
    }

    public JPanel createCenterPanel() {
        RelativeLayout rl = new RelativeLayout(1);
        rl.setAlignment(0.0f);
        rl.setFill(true);
        JPanel main = new JPanel(rl);
        JPanel insets = new JPanel(new GridLayout(0, 2, 5, 5));
        this.b = new JSpinner(new SpinnerNumberModel(5, 1, 1000, 2));
        this.b.addChangeListener(this);
        insets.add(this.b);
        insets.add(new JLabel("Scroll Frequency"));
        this.c = new JSpinner(new SpinnerNumberModel(5, 1, 10, 1));
        this.c.addChangeListener(this);
        insets.add(this.c);
        insets.add(new JLabel("Scroll Amount"));
        this.d = new JSpinner(new SpinnerNumberModel(199, -1, 399, 50));
        this.d.addChangeListener(this);
        insets.add(this.d);
        insets.add(new JLabel("Preferred Width"));
        main.add(insets);
        JCheckBox wrap = new JCheckBox("Wrap");
        wrap.setSelected(false);
        wrap.addItemListener(this);
        main.add(wrap);
        JPanel wrapPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        this.e = new JSpinner(new SpinnerNumberModel(50, 0, 500, 25));
        this.e.setEnabled(false);
        this.e.addChangeListener(this);
        wrapPanel.add(this.e);
        wrapPanel.add(new JLabel("Wrap Amount"));
        main.add(wrapPanel);
        JCheckBox scrollWhenFocused = new JCheckBox("Scroll When Focused");
        scrollWhenFocused.setSelected(true);
        scrollWhenFocused.addItemListener(this);
        main.add(scrollWhenFocused);
        JPanel panel = new JPanel();
        panel.add(main);
        return panel;
    }

    private JComponent b() {
        JPanel panel = new JPanel();
        JButton start = new JButton("Start");
        start.addActionListener(this);
        panel.add(start);
        JButton stop = new JButton("Stop");
        stop.addActionListener(this);
        panel.add(stop);
        JButton pause = new JButton("Pause");
        pause.addActionListener(this);
        panel.add(pause);
        JButton resume = new JButton("Resume");
        resume.addActionListener(this);
        panel.add(resume);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("Start".equals(command)) {
            this.a.startScrolling();
        }
        if ("Stop".equals(command)) {
            this.a.stopScrolling();
        }
        if ("Pause".equals(command)) {
            this.a.pauseScrolling();
        }
        if ("Resume".equals(command)) {
            this.a.resumeScrolling();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox checkBox = (JCheckBox)e.getSource();
        String command = checkBox.getText();
        if ("Wrap".equals(command)) {
            this.a.setWrap(checkBox.isSelected());
            this.e.setEnabled(checkBox.isSelected());
        } else {
            this.a.setScrollWhenFocused(checkBox.isSelected());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.a.setScrollFrequency((Integer)this.b.getValue());
        this.a.setScrollAmount((Integer)this.c.getValue());
        this.a.setPreferredWidth((Integer)this.d.getValue());
        this.a.setWrapAmount((Integer)this.e.getValue());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MarqueePanelDemo.createAndShowGUI();
            }
        });
    }

    public static void createAndShowGUI() {
        JFrame frame = new JFrame("Marquee Panel");
        frame.setDefaultCloseOperation(3);
        frame.add(new MarqueePanelDemo());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

