/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige.utils;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.sportdata.setpp.anzeige.constants.MainConstants;
import org.sportdata.setpp.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setpp.anzeige.ressource.AnzeigeResource;
import org.sportdata.setpp.anzeige.utils.FehlerFenster;

public class GrafikDeviceUtils {
    public static boolean hasExternalDevice() {
        try {
            GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            System.out.println("Default Graphic Device: " + defgraphicDevices.getIDstring());
            return graphicDevices.length > 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setExternalDeviceBounds(JFrame anzeige) {
        block8: {
            try {
                GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                System.out.println("Default Graphic Device: " + defgraphicDevices.getIDstring());
                if (graphicDevices.length > 1) {
                    int i = 0;
                    while (i < graphicDevices.length) {
                        if (!graphicDevices[i].getIDstring().equals(defgraphicDevices.getIDstring())) {
                            System.out.println("Use External Graphic Device for Main Panel: " + graphicDevices[i].getIDstring());
                            if (anzeige != null) {
                                Rectangle deviceBounds = graphicDevices[i].getDefaultConfiguration().getBounds();
                                anzeige.setBounds(deviceBounds);
                                anzeige.setExtendedState(6);
                                if (anzeige.isVisible()) {
                                    anzeige.setVisible(false);
                                    anzeige.dispose();
                                    anzeige.setUndecorated(true);
                                    anzeige.setVisible(true);
                                } else {
                                    anzeige.setVisible(false);
                                    anzeige.dispose();
                                    anzeige.setUndecorated(true);
                                }
                            }
                            break block8;
                        }
                        ++i;
                    }
                    break block8;
                }
                System.out.println("Could not find any external graphic devices. Use default graphic device for Main Panel: " + defgraphicDevices.getIDstring());
                new FehlerFenster(AnzeigeResource.getResourceString("external.graphic.device.notfound.error"));
            }
            catch (Exception e) {
                System.out.println("Error getting information of external graphic device!");
            }
        }
    }

    public static boolean setExternalDeviceBounds(JFrame anzeige, String deviceid) {
        boolean founddevice;
        block8: {
            founddevice = false;
            System.out.println("Check for saved External Graphic Device for Main Panel: " + deviceid);
            if (deviceid == null || deviceid.trim().equals("")) {
                return founddevice;
            }
            try {
                GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                if (graphicDevices.length <= 1) break block8;
                int i = 0;
                while (i < graphicDevices.length) {
                    if (!graphicDevices[i].getIDstring().equals(defgraphicDevices.getIDstring()) && graphicDevices[i].getIDstring().equals(deviceid)) {
                        System.out.println("Use saved External Graphic Device for Main Panel: " + graphicDevices[i].getIDstring());
                        if (anzeige != null) {
                            Rectangle deviceBounds = graphicDevices[i].getDefaultConfiguration().getBounds();
                            anzeige.setBounds(deviceBounds);
                            anzeige.setExtendedState(6);
                            if (anzeige.isVisible()) {
                                anzeige.setVisible(false);
                                anzeige.dispose();
                                anzeige.setUndecorated(true);
                                anzeige.setVisible(true);
                            } else {
                                anzeige.setVisible(false);
                                anzeige.dispose();
                                anzeige.setUndecorated(true);
                            }
                        }
                        founddevice = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error getting information of external graphic device!");
            }
        }
        return founddevice;
    }

    public static int getModeForExternalDevice() {
        try {
            GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            System.out.println("Default Graphic Device: " + defgraphicDevices.getIDstring());
            if (graphicDevices.length > 1) {
                int i = 0;
                while (i < graphicDevices.length) {
                    if (!graphicDevices[i].getIDstring().equals(defgraphicDevices.getIDstring())) {
                        System.out.println("Found External Graphic Device for Main Panel mode calculation: " + graphicDevices[i].getIDstring());
                        Rectangle deviceBounds = graphicDevices[i].getDefaultConfiguration().getBounds();
                        int j = 0;
                        while (j < MainConstants.DISPLAY_WITH.length) {
                            if (!(deviceBounds.getWidth() > (double)MainConstants.DISPLAY_WITH[j])) {
                                System.out.println("Mode found for Main Panel: " + j);
                                return j;
                            }
                            ++j;
                        }
                        return MainConstants.DISPLAY_WITH.length - 1;
                    }
                    ++i;
                }
            } else {
                System.out.println("Could not find any external graphic devices. Use default mode for Main Panel!");
            }
        }
        catch (HeadlessException e) {
            System.out.println("Error getting information of external graphic device for mode calculation!");
        }
        return 3;
    }

    public static Dimension getDefaultScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void setExternalDeviceBoundsSimple(JFrame anzeige) {
        block6: {
            try {
                GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                System.out.println("SET: Default Graphic Device: " + defgraphicDevices.getIDstring());
                if (graphicDevices.length > 1) {
                    int i = 0;
                    while (i < graphicDevices.length) {
                        if (!graphicDevices[i].getIDstring().equals(defgraphicDevices.getIDstring())) {
                            System.out.println("SET: Use External Graphic Device for Main Panel: " + graphicDevices[i].getIDstring());
                            if (anzeige != null) {
                                Rectangle deviceBounds = graphicDevices[i].getDefaultConfiguration().getBounds();
                                anzeige.setBounds(deviceBounds);
                                anzeige.setExtendedState(6);
                                anzeige.setUndecorated(true);
                            }
                            break block6;
                        }
                        ++i;
                    }
                    break block6;
                }
                Rectangle deviceBounds = defgraphicDevices.getDefaultConfiguration().getBounds();
                anzeige.setBounds(deviceBounds);
                anzeige.setExtendedState(6);
                anzeige.setUndecorated(true);
            }
            catch (Exception e) {
                System.out.println("SET: Error getting information of external graphic device!");
            }
        }
    }

    public static Rectangle getExternalDeviceBoundsSimple() {
        Rectangle deviceBounds;
        block5: {
            deviceBounds = null;
            try {
                GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                System.out.println("SET: Default Graphic Device: " + defgraphicDevices.getIDstring());
                if (graphicDevices.length > 1) {
                    int i = 0;
                    while (i < graphicDevices.length) {
                        if (!graphicDevices[i].getIDstring().equals(defgraphicDevices.getIDstring())) {
                            System.out.println("SET: Use External Graphic Device for Main Panel: " + graphicDevices[i].getIDstring());
                            deviceBounds = graphicDevices[i].getDefaultConfiguration().getBounds();
                            break block5;
                        }
                        ++i;
                    }
                    break block5;
                }
                deviceBounds = defgraphicDevices.getDefaultConfiguration().getBounds();
            }
            catch (Exception e) {
                System.out.println("SET: Error getting information of external graphic device!");
            }
        }
        return deviceBounds;
    }

    public static ArrayList<String> getExternalDevices() {
        ArrayList<String> devices = new ArrayList<String>();
        try {
            GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            System.out.println("Default Graphic Device: " + defgraphicDevices.getIDstring());
            if (graphicDevices.length > 1) {
                int i = 0;
                while (i < graphicDevices.length) {
                    if (!graphicDevices[i].getIDstring().equals(defgraphicDevices.getIDstring())) {
                        devices.add(graphicDevices[i].getIDstring());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error getting information of external graphic device!");
        }
        return devices;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasExternalDevice(String deviceid) {
        boolean founddevice = false;
        if (deviceid == null) return founddevice;
        if (deviceid.trim().equals("")) {
            return founddevice;
        }
        try {
            GraphicsDevice[] graphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            GraphicsDevice defgraphicDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            if (graphicDevices.length <= 1) return founddevice;
            int i = 0;
            while (true) {
                if (i >= graphicDevices.length) {
                    return founddevice;
                }
                if (!graphicDevices[i].getIDstring().equals(defgraphicDevices.getIDstring()) && graphicDevices[i].getIDstring().equals(deviceid)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return founddevice;
    }

    public static boolean hasAkaUniqueGraphicDevice() {
        String gd_main = AnzeigePropertiesHelper.getSetppExtgraphicdeviceMainpointpanel();
        String gd_aka = AnzeigePropertiesHelper.getSetppExtgraphicdeviceAKA();
        String gd_ao = AnzeigePropertiesHelper.getSetppExtgraphicdeviceAO();
        if (gd_main == null || gd_main.equals("") || gd_aka == null || gd_aka.equals("") || gd_ao == null || gd_ao.equals("")) {
            return false;
        }
        if (!(GrafikDeviceUtils.hasExternalDevice(gd_main) && GrafikDeviceUtils.hasExternalDevice(gd_aka) && GrafikDeviceUtils.hasExternalDevice(gd_ao))) {
            return false;
        }
        return !gd_aka.equals(gd_main) && !gd_aka.equals(gd_ao);
    }

    public static boolean hasAoUniqueGraphicDevice() {
        String gd_main = AnzeigePropertiesHelper.getSetppExtgraphicdeviceMainpointpanel();
        String gd_aka = AnzeigePropertiesHelper.getSetppExtgraphicdeviceAKA();
        String gd_ao = AnzeigePropertiesHelper.getSetppExtgraphicdeviceAO();
        if (gd_main == null || gd_main.equals("") || gd_aka == null || gd_aka.equals("") || gd_ao == null || gd_ao.equals("")) {
            return false;
        }
        if (!(GrafikDeviceUtils.hasExternalDevice(gd_main) && GrafikDeviceUtils.hasExternalDevice(gd_aka) && GrafikDeviceUtils.hasExternalDevice(gd_ao))) {
            return false;
        }
        return !gd_ao.equals(gd_main) && !gd_ao.equals(gd_aka);
    }
}

