/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.extension.serialinterface.wbclicker;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.sportdata.setpp.anzeige.beans.AnzeigeMaster;
import org.sportdata.setpp.anzeige.beans.ScoringObject;
import org.sportdata.setpp.anzeige.beans.VRObject;
import org.sportdata.setpp.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setpp.anzeige.utils.FehlerFenster;
import org.sportdata.setpp.extension.serialinterface.wbclicker.SerialConstants;
import org.sportdata.setpp.scores.ProcessScores;

public class ClickerSerialInterface {
    public static synchronized void sendSerialMessageSimpleDirectly(String s) {
        if (AnzeigeMaster.getInstance().isSerialPortOpenClicker() && s.length() > 0) {
            try {
                AnzeigeMaster.getInstance().getAcp().getLogcomp().getLoggerwb().info("Send Serial Clicker Interface: " + s.getBytes().length + " bytes sent. Content: " + s);
                System.out.println("Serial Clicker Interface: " + s.getBytes().length + " bytes sent. Content: " + s);
                AnzeigeMaster.getInstance().getSerialPortClicker().writeBytes(s.getBytes(), (long)s.getBytes().length);
            }
            catch (Exception ex) {
                new FehlerFenster("Error occurred while writing data.");
            }
        }
    }

    public static synchronized void sendSerialMessageSimple(String s) {
        ClickerSerialInterface.sendSerialMessageSimple(s, true);
    }

    public static synchronized void sendSerialMessageSimple(final String s, final boolean printonconsole) {
        if (AnzeigeMaster.getInstance().isSerialPortOpenClicker() && s.length() > 0) {
            try {
                Thread rt = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(SerialConstants.getWB_SLEEP());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            if (printonconsole) {
                                System.out.println("Serial Clicker Interface: " + s.getBytes().length + " bytes sent. Content: " + s);
                            }
                            AnzeigeMaster.getInstance().getAcp().getLogcomp().getLoggerwb().info("Send Serial Clicker Interface: " + s.getBytes().length + " bytes sent. Content: " + s);
                            AnzeigeMaster.getInstance().getSerialPortClicker().writeBytes(s.getBytes(), (long)s.getBytes().length);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, "Write Thread");
                rt.start();
            }
            catch (Exception ex) {
                new FehlerFenster("Error occurred while writing data.");
            }
        }
    }

    public static void handleInputMessage(byte[] buffer) {
        String message = new String(buffer);
        try {
            message = message.trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message.indexOf("s998#") > -1) {
            System.out.println("Serial Interface: Received Handshake Message sent from SET -> " + buffer.length + " bytes. Content: " + message);
        } else if (message.indexOf("s997#") > -1) {
            System.out.println("Serial Interface: Received Handshake Message sent from WB Master -> " + buffer.length + " bytes. Content: " + message);
            try {
                ClickerSerialInterface.sendSerialMessageSimple("s996#" + AnzeigeMaster.getInstance().deencodeSportdata4WB(ClickerSerialInterface.getHandshakeKey(message)) + "#e");
            }
            catch (Exception exception) {}
        } else if (message.indexOf("#192e") > -1 || message.indexOf("#193e") > -1) {
            AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyEventListeners(208, "");
            if (message.indexOf("#192e") > -1) {
                AnzeigeMaster.getInstance().appendFadeMessagePopupGeneral("Handshake error: key already sent!");
            }
            if (message.indexOf("#193e") > -1) {
                AnzeigeMaster.getInstance().appendFadeMessagePopupGeneral("Handshake error: wrong key or timeout!");
                AnzeigeMaster.getInstance().showFadeMessageClicker("images/wb_193.jpg");
            }
        } else {
            try {
                System.out.println("Serial Interface: Received " + buffer.length + " bytes. Content: " + message + " Command " + message.substring(9, 10));
                AnzeigeMaster.getInstance().getAcp().getLogcomp().getLoggerwb().info(message);
            }
            catch (Exception e) {
                System.out.println("Serial Interface: Received " + buffer.length + " bytes. Content: " + message);
                AnzeigeMaster.getInstance().getAcp().getLogcomp().getLoggerwb().info(message);
            }
            if (ClickerSerialInterface.isScoreMessage(message)) {
                ClickerSerialInterface.setRefereeScore(message);
            } else {
                AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyEventListeners(207, message);
            }
        }
    }

    public static boolean isScoreMessage(String message) {
        return message.substring(9, 10).equals("P");
    }

    public static boolean isErrorMessage(String message) {
        try {
            if (message.substring(9, 10).equals("F") && (ClickerSerialInterface.getErrorCode(message).equals("111") || ClickerSerialInterface.getErrorCode(message).equals("112") || ClickerSerialInterface.getErrorCode(message).equals("113") || ClickerSerialInterface.getErrorCode(message).equals("114") || ClickerSerialInterface.getErrorCode(message).equals("115") || ClickerSerialInterface.getErrorCode(message).equals("116") || ClickerSerialInterface.getErrorCode(message).equals("117"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getErrorCode(String message) {
        String code = "";
        try {
            if (message.substring(9, 10).equals("F")) {
                code = message.substring(message.indexOf("#") + 1, message.indexOf("e"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    public static String getHandshakeKey(String message) {
        String key = "";
        try {
            key = message.substring(message.indexOf("#") + 1, message.lastIndexOf("#"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return key;
    }

    public static String getErrorMessageLong(String message) {
        Object code = "Clicker Error: " + message;
        try {
            if (message.substring(9, 10).equals("F")) {
                code = message.substring(message.indexOf("#") + 1, message.indexOf("e"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((String)code).equals("111")) {
            code = "Clicker Error Code: " + (String)code + " -> CLICKER lost connection to MASTER -> CLICKER: " + ClickerSerialInterface.getDeviceFromMessage(message) + " (" + ClickerSerialInterface.getDeviceNameFromDeviceID(ClickerSerialInterface.getDeviceFromMessage(message)) + ")";
        }
        if (((String)code).equals("112")) {
            code = "Clicker Error Code: " + (String)code + " -> CLICKER (RED or BLUE) lost connection to HUB -> HUB: " + ClickerSerialInterface.getDeviceFromMessage(message) + " (" + ClickerSerialInterface.getDeviceNameFromDeviceID(ClickerSerialInterface.getDeviceFromMessage(message)) + ")";
        }
        if (((String)code).equals("113")) {
            code = "Clicker Error Code: " + (String)code + " -> MASTER lost connection to SET";
        }
        if (((String)code).equals("114")) {
            code = "Clicker Error Code: " + (String)code + " -> HUB lost connection to MASTER -> HUB: " + ClickerSerialInterface.getDeviceFromMessage(message) + " (" + ClickerSerialInterface.getDeviceNameFromDeviceID(ClickerSerialInterface.getDeviceFromMessage(message)) + ")";
        }
        if (((String)code).equals("115")) {
            code = "Clicker Error Code: " + (String)code + " -> CLICKER RED lost connection to HUB -> HUB: " + ClickerSerialInterface.getDeviceFromMessage(message) + " (" + ClickerSerialInterface.getDeviceNameFromDeviceID(ClickerSerialInterface.getDeviceFromMessage(message)) + ")";
        }
        if (((String)code).equals("116")) {
            code = "Clicker Error Code: " + (String)code + " -> CLICKER BLUE lost connection to HUB -> HUB: " + ClickerSerialInterface.getDeviceFromMessage(message) + " (" + ClickerSerialInterface.getDeviceNameFromDeviceID(ClickerSerialInterface.getDeviceFromMessage(message)) + ")";
        }
        if (((String)code).equals("117")) {
            code = "Clicker Error Code: " + (String)code + " -> CLICKER RED and BLUE lost connection to HUB -> HUB: " + ClickerSerialInterface.getDeviceFromMessage(message) + " (" + ClickerSerialInterface.getDeviceNameFromDeviceID(ClickerSerialInterface.getDeviceFromMessage(message)) + ")";
        }
        return code;
    }

    public static boolean isWarningOrInfo(String message) {
        try {
            if (message.substring(9, 10).equals("C") || message.substring(9, 10).equals("B")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isMasterInfo(String message, String masterid) {
        try {
            String device = ClickerSerialInterface.getDeviceFromMessage(message);
            if (!masterid.trim().equals("") && message.indexOf(masterid.toUpperCase()) > -1 && message.substring(9, 10).equals("B") && device.equals("INFO")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void getClickerInfos(String masterid) {
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + "CxxxBx#xe");
    }

    public static void resetMaster(String masterid) {
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + "CxxxE8#xe");
    }

    public static void infoMaster(String masterid, String val1) {
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + "xxxxB" + val1 + "#xe");
    }

    public static void pairDevice(String masterid, String deviceid, String mode, boolean reversed) {
        String colormode = "9";
        int cmode = 9;
        if (cmode > 4 && reversed) {
            ++cmode;
        }
        if (mode.equals("241")) {
            cmode = 1;
        }
        if (mode.equals("242")) {
            cmode = 2;
        }
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + deviceid + "M" + mode + "#" + cmode + "e");
    }

    public static void startDevices(String masterid, String val1, String val2) {
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + "CxxxG" + val1 + "#" + val2 + "e");
    }

    public static void startDevice(String masterid, String deviceid, String val1, String val2) {
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + deviceid + "G" + val1 + "#" + val2 + "e");
    }

    public static void stopDevices(String masterid) {
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + "CxxxSx#xe");
    }

    public static void stopDevice(String masterid, String deviceid) {
        ClickerSerialInterface.sendSerialMessageSimple("s" + masterid.trim() + deviceid + "Sx#xe");
    }

    public static String getMode(int row) {
        String mode = "WKF KUMITE";
        if (row == 8 || row == 9) {
            switch (row) {
                case 8: {
                    return "241";
                }
                case 9: {
                    return "242";
                }
            }
        } else if (mode.equals("WKF KUMITE")) {
            switch (row) {
                case 1: {
                    return "51";
                }
                case 2: {
                    return "52";
                }
                case 3: {
                    return "53";
                }
                case 4: {
                    return "54";
                }
                case 5: {
                    return "55";
                }
                case 6: {
                    return "56";
                }
                case 7: {
                    return "57";
                }
            }
        }
        return "";
    }

    public static String getDeviceFromMessage(String message) {
        try {
            return message.substring(5, 9);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String[] getDevicesProps() {
        String[] refprops = new String[]{};
        try {
            if (!AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().trim().equals("")) {
                refprops = AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().split(Pattern.quote("|"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return refprops;
    }

    public static String[] getDevicesPropsByMode() {
        String[] refprops = new String[]{};
        try {
            if (!AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().trim().equals("") && AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().indexOf("##MODE##") > -1) {
                String[] refpropsmode = ClickerSerialInterface.getDevicesProps();
                int i = 0;
                while (i < refpropsmode.length) {
                    if (refpropsmode[i].indexOf("##MODE##WKF KUMITE") > -1) {
                        refprops = refpropsmode[i].replace("##MODE##WKF KUMITE,", "").split(";");
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return refprops;
    }

    public static ArrayList<String> getDevicesForMode() {
        ArrayList<String> devices = new ArrayList<String>();
        if (!AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().trim().equals("")) {
            try {
                String[] refprops = ClickerSerialInterface.getDevicesPropsByMode();
                int i = 0;
                while (i < refprops.length) {
                    String[] refprop = refprops[i].split(",");
                    devices.add(refprop[0]);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return devices;
    }

    public static ArrayList<String> getDevicesNamesForMode() {
        ArrayList<String> devices = new ArrayList<String>();
        if (!AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().trim().equals("")) {
            try {
                String[] refprops = ClickerSerialInterface.getDevicesPropsByMode();
                int i = 0;
                while (i < refprops.length) {
                    String[] refprop = refprops[i].split(",");
                    devices.add(refprop[1]);
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return devices;
    }

    public static int getRefereeIDFromDeviceID(String device) {
        if (!AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().trim().equals("")) {
            try {
                ArrayList<String> devices = ClickerSerialInterface.getDevicesForMode();
                if (devices.contains(device)) {
                    return devices.indexOf(device);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String getDeviceIDFromDeviceName(String devicename) {
        String deviceid = "";
        if (!AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().trim().equals("")) {
            try {
                ArrayList<String> devices = ClickerSerialInterface.getDevicesForMode();
                ArrayList<String> devicesnames = ClickerSerialInterface.getDevicesNamesForMode();
                if (devicesnames.contains(devicename)) {
                    return devices.get(devicesnames.indexOf(devicename));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return deviceid;
    }

    public static String getDeviceNameFromDeviceID(String deviceid) {
        String devicename = "";
        if (!AnzeigePropertiesHelper.getSetwkfkataclickerswbconfig().trim().equals("")) {
            try {
                ArrayList<String> devices = ClickerSerialInterface.getDevicesForMode();
                ArrayList<String> devicesnames = ClickerSerialInterface.getDevicesNamesForMode();
                if (devices.contains(deviceid)) {
                    return devicesnames.get(devices.indexOf(deviceid));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return devicename;
    }

    public static float getScoreRed(String message) {
        String score = message.substring(10, message.indexOf("#"));
        try {
            return Float.parseFloat(score) / 10.0f;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
    }

    public static int getScoreRedNormal(String message) {
        String score = message.substring(10, message.indexOf("#"));
        try {
            return Integer.parseInt(score);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static float getScoreBlue(String message) {
        String score = message.substring(message.indexOf("#") + 1, message.indexOf("e"));
        try {
            return Float.parseFloat(score) / 10.0f;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
    }

    public static String getBattery(String message) {
        String score = "0";
        if (message.substring(9, 10).equals("C")) {
            score = message.substring(10, message.indexOf("#"));
        }
        if (message.substring(9, 10).equals("B")) {
            score = message.substring(10, message.indexOf("#"));
        }
        try {
            return score;
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public static String getSignal(String message) {
        String score = message.substring(message.indexOf("#") + 1, message.indexOf("e"));
        try {
            return score;
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public static void setRefereeScore(String message) {
        block19: {
            try {
                ScoringObject objvr2;
                if (!message.substring(9, 10).equals("P")) break block19;
                System.out.println("Send Score " + message);
                int referee = 0;
                float scorered = -1.0f;
                float scoreblue = -1.0f;
                String device = ClickerSerialInterface.getDeviceFromMessage(message);
                referee = ClickerSerialInterface.getRefereeIDFromDeviceID(device);
                scorered = ClickerSerialInterface.getScoreRed(message);
                scoreblue = ClickerSerialInterface.getScoreBlue(message);
                if (referee > 0 && referee < 8 && scorered > -1.0f && scoreblue > -1.0f) {
                    String mode = "WKF KUMITE".trim();
                    ScoringObject obj = new ScoringObject();
                    obj.setReferee(referee);
                    System.out.println(scorered);
                    if (ClickerSerialInterface.getScoreRedNormal(message) % 2 == 1) {
                        obj.setScorer("RED");
                    } else {
                        obj.setScorer("BLUE");
                    }
                    if (ClickerSerialInterface.getScoreRedNormal(message) == 3) {
                        obj.setScoreValue(1.0f);
                    }
                    if (ClickerSerialInterface.getScoreRedNormal(message) == 4) {
                        obj.setScoreValue(1.0f);
                    }
                    if (ClickerSerialInterface.getScoreRedNormal(message) == 5) {
                        obj.setScoreValue(2.0f);
                    }
                    if (ClickerSerialInterface.getScoreRedNormal(message) == 6) {
                        obj.setScoreValue(2.0f);
                    }
                    if (ClickerSerialInterface.getScoreRedNormal(message) == 7) {
                        obj.setScoreValue(3.0f);
                    }
                    if (ClickerSerialInterface.getScoreRedNormal(message) == 8) {
                        obj.setScoreValue(3.0f);
                    }
                    ProcessScores.processExternalScores(obj);
                }
                if (referee != 8 && referee != 9) break block19;
                VRObject obj = new VRObject();
                obj.setReferee(referee);
                if (AnzeigeMaster.getInstance().getAcp() == null || !AnzeigeMaster.getInstance().getAcp().getAnzeigeMain().isVisible() || AnzeigeMaster.getInstance().getAcp().getAnzeigeMain().getExtendedState() == 1) break block19;
                if (obj.getReferee() == 8) {
                    try {
                        if (AnzeigeMaster.getInstance().isTestmode()) {
                            objvr2 = new ScoringObject();
                            objvr2.setReferee(8);
                            AnzeigeMaster.getInstance().processTestScore(objvr2);
                        } else {
                            AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyEventListeners(150, "");
                        }
                    }
                    catch (Exception objvr2) {
                        // empty catch block
                    }
                }
                if (obj.getReferee() != 9) break block19;
                try {
                    if (AnzeigeMaster.getInstance().isTestmode()) {
                        objvr2 = new ScoringObject();
                        objvr2.setReferee(9);
                        AnzeigeMaster.getInstance().processTestScore(objvr2);
                        break block19;
                    }
                    AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(151, "");
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String generateRandomKey() {
        int randomint = (int)Math.floor(Math.random() * 9.0E7) + 10000000;
        return "" + randomint;
    }

    public static String generateEncryptedMessage(String randomkey) {
        String encryptedkey = "";
        try {
            encryptedkey = AnzeigeMaster.getInstance().encodeWB(randomkey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encryptedkey;
    }

    public static void sendVRCommand(String mastername, String devicename, String onoff) {
        String master = ClickerSerialInterface.getDeviceIDFromDeviceName(mastername);
        String vrdevice = ClickerSerialInterface.getDeviceIDFromDeviceName(devicename);
        System.out.println("WB Clicker VR Command -> " + mastername + " -> " + devicename + ": s" + master + vrdevice + "V1#" + onoff + "e");
        if (!master.equals("") && !vrdevice.equals("")) {
            ClickerSerialInterface.sendSerialMessageSimple("s" + master + vrdevice + "V1#" + onoff + "e");
        }
    }
}

