/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige.components;

import java.awt.Color;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setpp.anzeige.AnzeigeController;
import org.sportdata.setpp.anzeige.beans.AnzeigeMaster;
import org.sportdata.setpp.anzeige.components.Segment7;
import org.sportdata.setpp.anzeige.constants.MainConstants;
import org.sportdata.setpp.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setpp.anzeige.matchtime.MatchtimeHelper;
import org.sportdata.setpp.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setpp.anzeige.utils.DateUtils;

public class ClockComponent
extends JPanel
implements Runnable,
IAnzeigeEventListener {
    private int h = 3;
    private ExecutorService i = Executors.newSingleThreadExecutor();
    private static final long serialVersionUID = -1295753154920288726L;
    DecimalFormat a = new DecimalFormat("0");
    private volatile boolean j;
    long b = 100L;
    private Color k = MainConstants.TIME_COLOR;
    private long l;
    private long m = this.l = (long)(MatchtimeHelper.getMatchtime() * 1000);
    Segment7 c;
    Segment7 d;
    Segment7 e;
    Segment7 f;
    JLabel g;
    private AnzeigeController n;
    private boolean o;
    private ArrayList<String> p = new ArrayList();
    private ArrayList<String> q = new ArrayList();
    private ArrayList<String> r = new ArrayList();
    private int s = 0;

    public ClockComponent(Color color, int mode, AnzeigeController acontrol, boolean logging) {
        this.h = mode;
        this.n = acontrol;
        this.o = logging;
        this.checkBackground(true);
        this.setOpaque(true);
        this.setBackground(color);
        this.initComponent();
        this.registerPanel();
        if (!AnzeigePropertiesHelper.getPpusesimpledesign().equals("true") && !logging) {
            this.c.setFactor((int)((double)MainConstants.DISPLAY_SEGMENT_MIN_FACTOR[mode] * 1.2), (int)((double)MainConstants.DISPLAY_SEGMENT_MAX_FACTOR[mode] * 1.2));
            this.d.setFactor((int)((double)MainConstants.DISPLAY_SEGMENT_MIN_FACTOR[mode] * 1.2), (int)((double)MainConstants.DISPLAY_SEGMENT_MAX_FACTOR[mode] * 1.2));
            this.e.setFactor((int)((double)MainConstants.DISPLAY_SEGMENT_MIN_FACTOR[mode] * 1.2), (int)((double)MainConstants.DISPLAY_SEGMENT_MAX_FACTOR[mode] * 1.2));
            this.f.setFactor((int)((double)MainConstants.DISPLAY_SEGMENT_MIN_FACTOR[mode] * 0.6), (int)((double)MainConstants.DISPLAY_SEGMENT_MAX_FACTOR[mode] * 0.6));
        }
        this.setTimeValue();
        this.repaintClock();
    }

    public void checkBackground(boolean isidle) {
        if (isidle && AnzeigePropertiesHelper.getPpcoloridleothercolor().equals("true")) {
            this.a();
        } else {
            this.k = this.m <= 15000L ? Color.RED : (!AnzeigePropertiesHelper.getBackground().equals("black") ? MainConstants.TIME_COLOR_WHITE : MainConstants.TIME_COLOR);
        }
    }

    private void a() {
        this.k = !AnzeigePropertiesHelper.getBackground().equals("black") ? Color.GRAY : Color.LIGHT_GRAY;
    }

    public void setColor() {
        this.c.setColornofocus(this.k);
        this.d.setColornofocus(this.k);
        this.e.setColornofocus(this.k);
        this.g.setForeground(this.k);
        this.f.setColornofocus(this.k);
    }

    @Override
    public void registerPanel() {
        this.n.getListenersImp(this.h).add(this);
    }

    public void initComponent() {
        this.c = new Segment7(0, this.k, this.k, false, false, false, false, this.h);
        this.d = new Segment7(0, this.k, this.k, false, false, false, false, this.h);
        this.e = new Segment7(0, this.k, this.k, false, false, false, false, this.h);
        this.f = new Segment7(0, this.k, this.k, false, false, false, false, this.h);
        this.f.setAddstr(".");
        this.g = new JLabel(":");
        this.g.setHorizontalAlignment(0);
        this.g.setVerticalAlignment(0);
        this.g.setFont(MainConstants.DISPLAY_FONT_AKAAO_TEXT[this.h]);
        this.g.setForeground(this.k);
        this.add(this.c);
        this.add(this.g);
        this.add(this.d);
        this.add(this.e);
        this.add(this.f);
        this.f.getLtime().setFont(new Font("Dialog", 1, MainConstants.DISPLAY_SEGMENT_MAX_FACTOR[this.h] * 10));
        this.f.getLtime().setVerticalAlignment(3);
    }

    public void setTime(long seconds) {
        this.m = this.l = seconds;
        this.n.setLasttime(this.m);
    }

    public void reset() {
        this.m = this.l;
        this.setTimeValue();
        this.repaintClock();
    }

    @Override
    public void run() {
        this.j = true;
        this.m = this.n.getLasttime();
        this.checkBackground(false);
        this.setColor();
        this.repaintClock();
        this.p.add(DateUtils.getDateFormatedShort());
        while (this.j && this.m > 0L) {
            long systemtime = System.nanoTime();
            try {
                Thread.sleep(this.b);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long systemtimenew = System.nanoTime();
            if (!this.j) continue;
            long lastsecondsact = this.m + 0L;
            this.m -= (systemtimenew - systemtime) / 1000000L;
            if (this.m < 0L) {
                this.m = 0L;
            }
            this.setTimeValue();
            this.repaintClock();
            long cfr_ignored_0 = lastsecondsact / 100L;
            long cfr_ignored_1 = this.m / 100L;
            if (lastsecondsact / 1000L != this.m / 1000L) {
                if (this.o) {
                    this.i.submit(() -> this.n.notifyListeners(145, "" + this.getSecoundsact()));
                }
                ++this.s;
            }
            if (lastsecondsact < 15000L || this.m >= 15000L) continue;
            this.checkBackground(false);
            this.setColor();
            this.repaintClock();
            if (!this.o) continue;
            this.n.notifyListeners(42, "" + this.getSecoundsact());
            this.n.notifyListeners(88, "Seconds left:" + this.getSecoundsact());
        }
        if (this.o) {
            this.n.setLasttime(this.m);
        }
        if (this.m == 0L) {
            this.q.add(DateUtils.getDateFormatedShort());
            if (this.o) {
                this.n.notifyListeners(43, "" + this.m / 1000L);
                this.n.notifyListeners(89, "");
                this.n.notifyListeners(45, "" + this.m / 1000L);
            }
        }
        this.syncTimeDelayed();
        this.checkBackground(true);
        this.setColor();
        this.repaintClock();
        this.q.add(DateUtils.getDateFormatedShort());
    }

    public void stopClock() {
        if (this.j) {
            this.q.add(DateUtils.getDateFormatedShort());
            this.j = false;
        }
    }

    public void setTimeValue() {
        int secondcount = (int)(this.m / 1000L);
        int minval = secondcount / 60;
        int sek1val = (secondcount - minval * 60) / 10;
        int sek2val = secondcount - minval * 60 - sek1val * 10;
        int sek3val = (int)((this.m - (long)(secondcount * 1000)) / 100L);
        this.c.setValue(minval);
        this.d.setValue(sek1val);
        this.e.setValue(sek2val);
        this.f.setValue(sek3val);
    }

    public void repaintClock() {
        this.c.repaint();
        this.d.repaint();
        this.e.repaint();
        this.f.repaint();
    }

    public int getSecoundsact() {
        if (this.m % 1000L == 0L) {
            return (int)this.m / 1000;
        }
        return (int)(this.m / 1000L + 1L);
    }

    public int getSecoundsstart() {
        if (this.l % 1000L == 0L) {
            return (int)this.l / 1000;
        }
        return (int)(this.l / 1000L + 1L);
    }

    @Override
    public void update(int event, String message) {
        if (event == 0 && this.o) {
            this.n.notifyListeners(46, "Seconds left:" + this.getSecoundsact());
        }
        if (event == 1 && this.o) {
            this.n.notifyListeners(47, "Seconds left:" + this.getSecoundsact());
        }
        if (event == 2) {
            try {
                BigDecimal dec = new BigDecimal(message).multiply(new BigDecimal(10));
                this.m = dec.intValue() * 100;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m = 180000L;
            }
            this.setTime(this.m);
            this.reset();
            if (this.o) {
                this.n.notifyListeners(48, "Seconds left:" + this.getSecoundsact());
            }
        }
        if (event == 44) {
            this.stopClock();
            this.reset();
            this.b();
            this.c();
        }
        if (event == 111) {
            this.setTime(60000L);
            this.reset();
        }
        if (event == 89 && !this.o) {
            this.m = 0L;
            this.setTimeValue();
            this.repaintClock();
        }
        if (event == 161) {
            this.m += 1000L;
            this.n.setLasttime(this.m);
            this.setTimeValue();
            this.repaintClock();
            if (this.o) {
                this.n.notifyListeners(163, " ADD 1 SECOND -> Seconds left:" + this.getSecoundsact());
            }
        }
        if (event == 162) {
            this.m -= 1000L;
            this.n.setLasttime(this.m);
            this.setTimeValue();
            this.repaintClock();
            if (this.o) {
                this.n.notifyListeners(164, " REMOVE 1 SECOND -> Seconds left:" + this.getSecoundsact());
            }
        }
    }

    public boolean isRunningTrue() {
        return this.j;
    }

    private void b() {
        this.p.clear();
        this.q.clear();
        this.r.clear();
    }

    public ArrayList<String> getClockstart() {
        return this.p;
    }

    public void setClockstart(ArrayList<String> clockstart) {
        this.p = clockstart;
    }

    public ArrayList<String> getClockend() {
        return this.q;
    }

    public void setClockend(ArrayList<String> clockend) {
        this.q = clockend;
    }

    public long getSecoundsactNormal() {
        return this.m;
    }

    public String getFormatedDateStringShort() {
        long min = TimeUnit.MILLISECONDS.toMinutes(this.getSecoundsactNormal()) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(this.getSecoundsactNormal()) % 60L;
        String toRet = String.format("%01d:%02d", min, sec);
        return toRet;
    }

    public String getFormatedDateStringShortLong() {
        long min = TimeUnit.MILLISECONDS.toMinutes(this.getSecoundsactNormal()) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(this.getSecoundsactNormal()) % 60L;
        int secondcount = (int)(this.m / 1000L);
        int sek3val = (int)((this.m - (long)(secondcount * 1000)) / 100L);
        String toRet = String.format("%02d:%02d.%01d", min, sec, sek3val);
        if (min < 10L) {
            toRet = String.format("%01d:%02d.%01d", min, sec, sek3val);
        }
        return toRet;
    }

    public static String getFormatedDateStringShort(int seconds) {
        long min = TimeUnit.MILLISECONDS.toMinutes(seconds * 1000) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(seconds * 1000) % 60L;
        String toRet = String.format("%01d:%02d", min, sec);
        return toRet;
    }

    public static String getFormatedDateStringShortMMSS(int seconds) {
        long min = TimeUnit.MILLISECONDS.toMinutes(seconds * 1000) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(seconds * 1000) % 60L;
        String toRet = String.format("%02d:%02d", min, sec);
        return toRet;
    }

    public int getTotalmatchtime() {
        return this.s;
    }

    public void setTotalmatchtime(int totalmatchtime) {
        this.s = totalmatchtime;
    }

    private void c() {
        this.s = 0;
    }

    public ArrayList<String> getClockendautomatic() {
        return this.r;
    }

    public void setClockendautomatic(ArrayList<String> clockendautomatic) {
        this.r = clockendautomatic;
    }

    public boolean canStartTime() {
        if (AnzeigeMaster.getInstance().isTestmode()) {
            AnzeigeMaster.getInstance().clickerTestToFront();
            return false;
        }
        if (this.r.size() > 0) {
            String lastautomaticstop = this.r.get(this.r.size() - 1);
            return DateUtils.checkIsAfter(DateUtils.getDateFormatedShort(), lastautomaticstop);
        }
        return true;
    }

    public void syncTimeDelayed() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!ClockComponent.this.isRunningTrue()) {
                    ClockComponent.this.m = ClockComponent.this.n.getLasttime();
                    ClockComponent.this.setTimeValue();
                    ClockComponent.this.checkBackground(true);
                    ClockComponent.this.setColor();
                    ClockComponent.this.repaintClock();
                    System.out.println("Clock synced " + ClockComponent.this.m + " -> " + ClockComponent.this.getFormatedDateStringShortLong());
                }
            }
        };
        Timer timer = new Timer("Timer");
        long delay = 500L;
        timer.schedule(task, delay);
    }
}

