/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setpp.anzeige.components.ScoreComponent;
import org.sportdata.setpp.anzeige.constants.MainConstants;
import org.sportdata.setpp.anzeige.interfaces.ITimer;
import org.sportdata.setpp.anzeige.ressource.AnzeigeResource;
import org.sportdata.setpp.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setpp.anzeige.utils.License;
import org.sportdata.setpp.anzeige.version.Version;

public class ScoreClockPanel
extends JFrame
implements ActionListener,
ITimer {
    private static final long serialVersionUID = -1003801023381257450L;
    private JPanel a;
    private ScoreComponent b;
    private JButton c;
    private JLabel d;
    private int e;
    private JComboBox<String> f;
    private JLabel g;
    private ArrayList<Integer> h;
    private int i = 0;

    public ScoreClockPanel(ScoreComponent clock, int colormode) {
        this.b = clock;
        this.e = colormode;
        String colortitle = "";
        colortitle = colormode == 1 ? "AKA" : "AO";
        this.setTitle(colortitle + " SCORE - " + Version.getCopyright() + " (" + License.getLicense() + ")");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        if (colormode == 1) {
            this.setBounds((screenSize.width - 0) / 2, (screenSize.height - 520) / 2, 300, 200);
        } else {
            this.setBounds((screenSize.width - 0) / 2, (screenSize.height - 130) / 2, 300, 200);
        }
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initComponent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ScoreClockPanel.this.stopClock();
                ScoreClockPanel.this.closeWindow();
            }
        });
        clock.setTimerlabel(this);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.c.requestFocus();
    }

    public void initComponent() {
        this.a = new JPanel();
        this.a.setLayout(new GridLayout(4, 1));
        this.c = new JButton(AnzeigeResource.getResourceString("general.stop"));
        this.c.addActionListener(this);
        JLabel ltext = new JLabel(AnzeigeResource.getResourceString("general.timer"));
        JPanel pbuttons = new JPanel();
        pbuttons.add(ltext);
        pbuttons.add(this.c);
        this.c.setEnabled(false);
        this.d = new JLabel("");
        this.d.setFont(new Font("Dialog", 1, 20));
        if (this.e == 1) {
            this.d.setForeground(MainConstants.AKA_COLOR);
        } else {
            this.d.setForeground(MainConstants.AO_COLOR);
        }
        JPanel ptime = new JPanel();
        ptime.add(this.d);
        this.f = new JComboBox();
        this.f.addItem("");
        this.f.addItem("Yuko");
        this.f.addItem("Waza-ari");
        this.f.addItem("Ippon");
        this.f.addItem("VOTES 0");
        this.f.addItem("VOTES 1");
        this.f.addItem("VOTES 2");
        this.f.addItem("VOTES 3");
        this.f.addItem("VOTES 4");
        this.f.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                ScoreClockPanel.this.b.setValueText(ScoreClockPanel.this.f.getSelectedItem().toString());
            }
        });
        this.g = new JLabel();
        this.g.setHorizontalAlignment(0);
        this.g.setVerticalAlignment(0);
        this.a.add(ptime);
        this.a.add(pbuttons);
        this.a.add(this.f);
        this.a.add(this.g);
        this.add(this.a);
    }

    public void stopClock() {
        this.b.stopClock();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source.equals(this.c)) {
            this.stopClock();
        }
    }

    @Override
    public void updateTimerLabel(String timestring) {
        this.d.setText(timestring);
        this.d.repaint();
    }

    public int getColormode() {
        return this.e;
    }

    public void setColormode(int colormode) {
        this.e = colormode;
    }

    public void closeWindow() {
        this.b.closeWindow();
        this.setVisible(false);
        this.dispose();
    }

    public void setFullScreen() {
        this.b.changeFontsize(160);
        this.b.setExtendedState(6);
    }

    public void setNormalSize() {
        this.b.changeFontsize(80);
        this.b.setExtendedState(0);
    }

    public void setScoreType(String setitem) {
        try {
            this.f.setSelectedItem(setitem);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.b.setValueText(setitem);
    }

    public void addAdditionalText(String addtext) {
        this.b.addAdditionalText(addtext);
    }

    public void setClockSize(int w, int h) {
        this.b.setSize(w, h);
    }

    public void setClockLocation(int x, int y) {
        this.b.setLocation(x, y);
    }

    public void setPenalties(int penalty, int penalty2) {
        this.b.setPenalties(penalty, penalty2);
    }

    public ArrayList<Integer> getRefs() {
        return this.h;
    }

    public void setRefs(ArrayList<Integer> refs) {
        this.h = refs;
    }

    public ScoreComponent getClock() {
        return this.b;
    }

    public int getRefcount() {
        return this.i;
    }

    public void setRefcount(int refcount) {
        this.i = refcount;
    }

    public int getCBVAlueIndex() {
        return this.f.getSelectedIndex();
    }
}

