/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setpp.anzeige.components.SimpleClockComponent;
import org.sportdata.setpp.anzeige.constants.MainConstants;
import org.sportdata.setpp.anzeige.interfaces.ITimer;
import org.sportdata.setpp.anzeige.ressource.AnzeigeResource;
import org.sportdata.setpp.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setpp.anzeige.utils.License;
import org.sportdata.setpp.anzeige.version.Version;

public class SimpleClockPanel
extends JFrame
implements ActionListener,
ITimer {
    private static final long serialVersionUID = -1003801023381257450L;
    private JPanel a;
    private SimpleClockComponent b;
    private JButton c;
    private JButton d;
    private JLabel e;

    public SimpleClockPanel(SimpleClockComponent clock) {
        this.b = clock;
        this.setTitle(Version.getCopyright() + " (" + License.getLicense() + ")");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        this.setBounds((screenSize.width - 300) / 2, (screenSize.height - 150) / 2, 300, 150);
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initComponent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SimpleClockPanel.this.stopClock();
                SimpleClockPanel.this.closeClock();
                SimpleClockPanel.this.setVisible(false);
                SimpleClockPanel.this.dispose();
            }
        });
        clock.setTimerlabel(this);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.d.requestFocus();
    }

    public void initComponent() {
        this.a = new JPanel();
        this.a.setLayout(new GridLayout(2, 1));
        this.c = new JButton(AnzeigeResource.getResourceString("general.stop"));
        this.c.addActionListener(this);
        this.d = new JButton(AnzeigeResource.getResourceString("general.close"));
        this.d.addActionListener(this);
        JLabel ltext = new JLabel(AnzeigeResource.getResourceString("general.timer"));
        JPanel pbuttons = new JPanel();
        pbuttons.add(ltext);
        pbuttons.add(this.c);
        pbuttons.add(this.d);
        this.e = new JLabel("");
        this.e.setFont(new Font("Dialog", 1, 20));
        this.e.setForeground(MainConstants.AKA_COLOR);
        JPanel ptime = new JPanel();
        ptime.add(this.e);
        this.a.add(ptime);
        this.a.add(pbuttons);
        this.add(this.a);
    }

    public void stopClock() {
        this.b.stopClock();
    }

    public void closeClock() {
        this.b.setVisible(false);
        this.b.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source.equals(this.c)) {
            this.stopClock();
        }
        if (source.equals(this.d)) {
            this.stopClock();
            this.closeClock();
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void updateTimerLabel(String timestring) {
        this.e.setText(timestring);
        this.e.repaint();
    }
}

